-- FUNCTION: public.ufd_prod_equiv_apresentacao_comis(integer, integer, integer, integer, integer)

-- DROP FUNCTION IF EXISTS public.ufd_prod_equiv_apresentacao_comis(integer, integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_prod_equiv_apresentacao_comis(
	integer,
	integer,
	integer,
	integer,
	integer)
    RETURNS SETOF rs_equiv_apresentacao_comis 
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
    ROWS 1000

AS $BODY$
--<<inicio do corpo da funcao
	-- function: select * from ufd_est_prod_tbl_desc_preco_fabrica(1, 4, 1, 1)
	--declara as variaveis usadas na funcao
	declare
	---------------------------------------------------------
	----declara as variaveis que estao no cabecalho da funcao
	---------------------------------------------------------
	int_cd_filial           alias for $1;
	int_cd_prod             alias for $2;
	int_mesma_pres          alias for $3;
	int_cd_emp				alias for $4;
	int_cd_vendedor			alias for $5;
	
	is_ctr_custo_semafaro   integer;
	varTemp					varchar(100);
	returnrecComis          rs_equiv_apresentacao_comis;
	begin
	
		begin
			create temporary table temp_rs_equiv_apresentacao_comis
			(	cd_prod integer,
				ds_prod character varying(255),
				vlr_tabela double precision,
				ds_apres character varying(255),
				ds_arv_merc_equi character varying(255),
				qt_est integer,
				nm_fabric character varying(255),
				ds_sigla_linha character varying(255),
				vlr_custo double precision,
				perc_comis double precision);
				
			exception when others then
			truncate table temp_rs_equiv_apresentacao_comis; -- trunca a tabela se ela ja existir na corrente sessao.
		end;
		
		is_ctr_custo_semafaro = coalesce((select cast(coalesce(valor, '0') as integer) from prc_emp_config where cd_chave = 'ctr_custo_semaforo'),0);
						
		
		if coalesce((select cast(coalesce(valor, '0') as integer) from prc_emp_config where cd_chave='flag_tipo_pesquisa_equivalencia'), 0) = 0  then
			insert into temp_rs_equiv_apresentacao_comis
			select prod.cd_prod,
				   prod.ds_prod,
				   preco.vlr_tabela,
				   prod.ds_usual                       as ds_apres,
				   prin_ativo.ds_princ_ativos          as ds_arv_merc_equi,
				   prod_cpl.qt_est,
				   prod_fabric.nm_fabric,
				   est_arv_merc_linha.ds_sigla_linha,
				   (select case is_ctr_custo_semafaro
							 when 0 then vlr_custo
							 else vlr_custo_md
						   end
					from   est_prod_cpl
					where  cd_emp = int_cd_emp
						   and cd_filial = int_cd_filial
						   and cd_prod = prod.cd_prod) as vlr_custo,
					(select ufd_est_prod_tbl_comis(int_cd_emp,int_cd_filial,prod.cd_prod::integer,int_cd_vendedor)) as perc_comis
			from   est_prod as prod
				   inner join est_prod_princ_ativos_est_prod as prin_ativo_ret
						   on prod.cd_emp = prin_ativo_ret.cd_emp
							  and prod.cd_prod = prin_ativo_ret.cd_prod
				   inner join est_prod_princ_ativos as prin_ativo
						   on prin_ativo_ret.cd_princ_ativos = prin_ativo.cd_princ_ativos
				   inner join est_prod_princ_ativos_est_prod as prin_ativo_prod_cons
						   on prin_ativo.cd_princ_ativos = prin_ativo_prod_cons.cd_princ_ativos
							  and prin_ativo_prod_cons.cd_prod <> prin_ativo_ret.cd_prod
				   inner join est_prod_cpl as prod_cpl
						   on prod.cd_emp = prod_cpl.cd_emp
							  and prod.cd_prod = prod_cpl.cd_prod
				   inner join est_prod_preco as preco
						   on prod_cpl.cd_emp = preco.cd_emp
							  and prod_cpl.cd_filial = preco.cd_filial
							  and prod_cpl.cd_prod = preco.cd_prod
				   inner join est_prod_fabric as prod_fabric
						   on prod.cd_fabric = prod_fabric.cd_fabric
				   inner join est_prod_est_arv_mercadologica as prod_arv_merc
						   on prod.cd_emp = prod_arv_merc.cd_emp
							  and prod.cd_prod = prod_arv_merc.cd_prod
				   inner join est_arv_merc_linha
						   on prod_arv_merc.cd_arv_merc_linha = est_arv_merc_linha.cd_arv_merc_linha
							  and prod_arv_merc.cd_emp = est_arv_merc_linha.cd_emp
			where  ( prin_ativo_prod_cons.cd_prod = int_cd_prod )
				   and ( prod_cpl.cd_filial = int_cd_filial )
			order  by preco.vlr_tabela,prod_cpl.qt_est desc ;
			
		else
			
			if int_mesma_pres = 1 then
				insert into temp_rs_equiv_apresentacao_comis
				select ep_retorno.cd_prod,
					   ep_retorno.ds_prod,
					   epp.vlr_tabela,
					   eama.ds_apres,
					   eame.ds_arv_merc_equi,
					   epl.qt_est,
					   epf.nm_fabric,
					   eaml.ds_sigla_linha,
					   (select case is_ctr_custo_semafaro
								 when 0 then vlr_custo
								 else vlr_custo_md
							   end
						from   est_prod_cpl
						where  cd_emp = int_cd_emp
							   and cd_filial = int_cd_filial
							   and cd_prod = ep_retorno.cd_prod) as vlr_custo,
				       (select ufd_est_prod_tbl_comis(int_cd_emp,int_cd_filial,ep_retorno.cd_prod::integer,int_cd_vendedor)) as perc_comis
				from   est_prod_est_arv_mercadologica as epeam_retorno
					   inner join est_prod as ep_retorno
							   on epeam_retorno.cd_emp = ep_retorno.cd_emp
								  and epeam_retorno.cd_prod = ep_retorno.cd_prod
					   inner join est_prod_est_arv_mercadologica as epeam_cons
							   on epeam_retorno.cd_emp = epeam_cons.cd_emp
								  and epeam_retorno.cd_apres = epeam_cons.cd_apres
								  and epeam_retorno.cd_arv_merc_equi = epeam_cons.cd_arv_merc_equi
					   inner join est_prod as ep_cons
							   on epeam_cons.cd_emp = ep_cons.cd_emp
								  and epeam_cons.cd_prod = ep_cons.cd_prod
								  and epeam_cons.cd_apres > 0
								  and epeam_cons.cd_arv_merc_equi > 0
								  and ep_retorno.cd_prod <> ep_cons.cd_prod
					   inner join est_prod_cpl as epl
							   on ep_retorno.cd_emp = epl.cd_emp
								  and ep_retorno.cd_prod = epl.cd_prod
					   inner join est_prod_preco as epp
							   on epl.cd_emp = epp.cd_emp
								  and epl.cd_filial = epp.cd_filial
								  and epl.cd_prod = epp.cd_prod
					   inner join est_arv_merc_equivalente as eame
							   on epeam_retorno.cd_emp = eame.cd_emp
								  and epeam_retorno.cd_arv_merc_equi = eame.cd_arv_merc_equi
					   inner join est_arv_merc_apresentacao as eama
							   on epeam_retorno.cd_emp = eama.cd_emp
								  and epeam_retorno.cd_apres = eama.cd_apres
					   inner join est_prod_fabric as epf
							   on ep_retorno.cd_fabric = epf.cd_fabric
					   inner join est_arv_merc_linha as eaml
							   on epeam_retorno.cd_emp = eaml.cd_emp
								  and epeam_retorno.cd_arv_merc_linha = eaml.cd_arv_merc_linha
				where  ( epl.cd_filial = int_cd_filial )
					   and ( ep_cons.cd_prod = int_cd_prod )
				order  by eama.ds_apres,epp.vlr_tabela,epl.qt_est desc ;

			else
				insert into temp_rs_equiv_apresentacao_comis
				select ep_retorno.cd_prod,
					   ep_retorno.ds_prod,
					   epp.vlr_tabela,
					   eama.ds_apres,
					   eame.ds_arv_merc_equi,
					   epl.qt_est,
					   epf.nm_fabric,
					   eaml.ds_sigla_linha,
					   (select case is_ctr_custo_semafaro
								 when 0 then vlr_custo
								 else vlr_custo_md
							   end
						from   est_prod_cpl
						where  cd_emp = int_cd_emp
							   and cd_filial = int_cd_filial
							   and cd_prod = ep_retorno.cd_prod) as vlr_custo,
					   (select ufd_est_prod_tbl_comis(int_cd_emp,int_cd_filial,ep_retorno.cd_prod::integer,int_cd_vendedor)) as perc_comis
				from   est_prod_est_arv_mercadologica as epeam_retorno
					   inner join est_prod as ep_retorno
							   on epeam_retorno.cd_emp = ep_retorno.cd_emp
								  and epeam_retorno.cd_prod = ep_retorno.cd_prod
					   inner join est_prod_est_arv_mercadologica as epeam_cons
							   on epeam_retorno.cd_emp = epeam_cons.cd_emp
								  and epeam_retorno.cd_arv_merc_equi = epeam_cons.cd_arv_merc_equi
					   inner join est_prod as ep_cons
							   on epeam_cons.cd_emp = ep_cons.cd_emp
								  and epeam_cons.cd_prod = ep_cons.cd_prod
								  and epeam_cons.cd_apres > 0
								  and epeam_cons.cd_arv_merc_equi > 0
								  and ep_retorno.cd_prod <> ep_cons.cd_prod
					   inner join est_prod_cpl as epl
							   on ep_retorno.cd_emp = epl.cd_emp
								  and ep_retorno.cd_prod = epl.cd_prod
					   inner join est_prod_preco as epp
							   on epl.cd_emp = epp.cd_emp
								  and epl.cd_filial = epp.cd_filial
								  and epl.cd_prod = epp.cd_prod
					   inner join est_arv_merc_equivalente as eame
							   on epeam_retorno.cd_emp = eame.cd_emp
								  and epeam_retorno.cd_arv_merc_equi = eame.cd_arv_merc_equi
					   inner join est_arv_merc_apresentacao as eama
							   on epeam_retorno.cd_emp = eama.cd_emp
								  and epeam_retorno.cd_apres = eama.cd_apres
					   inner join est_prod_fabric as epf
							   on ep_retorno.cd_fabric = epf.cd_fabric
					   inner join est_arv_merc_linha as eaml
							   on epeam_retorno.cd_emp = eaml.cd_emp
								  and epeam_retorno.cd_arv_merc_linha = eaml.cd_arv_merc_linha
				where  ( epl.cd_filial = int_cd_filial )
					   and ( ep_cons.cd_prod = int_cd_prod )
				order  by eama.ds_apres,epp.vlr_tabela,epl.qt_est desc ;

			end if;
			
		end if;
		
		for returnrecComis in 
			select * from temp_rs_equiv_apresentacao_comis
		loop
			return next returnrecComis;
		end loop;			
	end; --fim dos blocos da funcao
$BODY$;

ALTER FUNCTION public.ufd_prod_equiv_apresentacao_comis(integer, integer, integer, integer, integer)
    OWNER TO postgres;
